/*
   Run the child with one of its stdout or stderr
   streams not tied to anything. The other output
   stream should be read by this parent process.
   That way, this parent process can see when the
   child fills up its output buffer (and hangs).
*/
import java.util.Scanner;
import java.io.*;

public class Ex1_OutputBufferCounter
{
   public static void main(String[] args) throws IOException
   {
      // Command line for running the child.
      String[] cmd = {"java", "Ex1_OutputBufferCounter_Child"};
      // Execute the command line.
      final Process process = Runtime.getRuntime().exec(cmd);
      // Give this parent the ability to shut down the child.
      Runtime.getRuntime().addShutdownHook(new Thread(){public void run(){process.destroy();}});


      // A stream that reads data from child's stderr stream.
      Scanner outputFromChild = new Scanner( process.getErrorStream() );
      // Or, read child's stdout stream (to see how big the stderr buffer is).
      //Scanner outputFromChild = new Scanner( process.getInputStream() );

      // Read as many lines as possible from OutputBufferCounter
      while ( outputFromChild.hasNextLine() )
      {
         String oneLine = outputFromChild.nextLine();
         System.out.println( oneLine );
      }
   }
}